--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNcamParams ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCobj
  local LOCcontroller
  local LOCparLength
  local LOCrangeSwitch = false
  local LOCspinStartValue
  local LOCundoState = on

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNcamParams FUNobj FUNcontroller =
  (
    DYNcamParams.LOCobj             = FUNobj
    DYNcamParams.LOCcontroller      = FUNcontroller
    if FUNcontroller != undefined then
    (
      DYNcamParams.LOCcontroller      = FUNcontroller
      DYNcamParams.LOCparLength       = try (curveLength FUNcontroller.path) catch (0.0)
      try
      (
        DYNcamParams.SPDYNtarg.value    = FUNcontroller.distance * DYNcamParams.LOCparLength
        DYNcamParams.SPDYNtarg.enabled  = true
      )
      catch
      (
        DYNcamParams.SPDYNtarg.value    = FUNobj.baseObject.targetDistance
        DYNcamParams.SPDYNtarg.enabled  = false
      )
    )
    else
    (
      DYNcamParams.SPDYNtarg.enabled  = false
    )

    DYNcamParams.SPDYNtilt.value    = in coordsys local (FUNobj.objectoffsetrot.x)
    DYNcamParams.SPDYNfogN.value    = FUNobj.nearRange
    DYNcamParams.SPDYNfogF.value    = FUNobj.farRange

    --- Set Up FOV DropDown List
    if (findItem DYNfovSizes FUNobj.fov) != 0 then
    (
      local TempParamArray = #() ; TempParamArray[DYNlensSizes.count] = undefined
      for i = 1 to DYNlensSizes.count do TempParamArray[i] = (DYNuiResourcesLabels[84] + " " + (DYNlensSizes[i] as string) + "mm")
      DYNcamParams.DDVISobjectParam.enabled   = true
      DYNcamParams.DDVISobjectParam.items     = TempParamArray
      DYNcamParams.DDVISobjectParam.selection = (findItem DYNfovSizes FUNobj.fov)
    )
    else
    (
      DYNcamParams.DDVISobjectParam.enabled   = false
      DYNcamParams.DDVISobjectParam.items     = #()
    )

	try
	(
        DYNcamParams.LOCrangeSwitch = not FUNobj.showRanges
	)
	catch
	(
	    --- showRange property doesn't exist (e.g. on Physical Camera)
	    DYNcamParams.LOCrangeSwitch = false
	)
  )


  ---SECTION 3 - DEFINE PANEL LAYOUT---
  groupbox GBDYNgroup01 width:(DYNiniExplorerWidth - 21) pos:[4,7] height:160
  button  BUDYNview height:25 pos:[11,26] width:(DYNiniExplorerWidth - 36)
  dropdownlist DDVISobjectParam pos:[11,56] width:(DYNiniExplorerWidth - 36)
  label LBDYNtarg pos:[11,83]  width:130
  label LBDYNfogN pos:[11,104] width:130
  label LBDYNfogF pos:[11,125] width:130
  label LBDYNtilt pos:[11,146] width:130

  spinner SPDYNtarg "" range:[-9999,9999,0.0]   type:#worldunits align:#right scale:1.0  fieldwidth:60 pos:[(DYNiniExplorerWidth - 96),83]
  spinner SPDYNfogN "" range:[0.0,999999.0,0.0] type:#worldunits align:#right scale:1.0  fieldwidth:60 pos:[(DYNiniExplorerWidth - 96),104]
  spinner SPDYNfogF "" range:[0.0,999999.0,0.0] type:#worldunits align:#right scale:1.0  fieldwidth:60 pos:[(DYNiniExplorerWidth - 96),125]
  spinner SPDYNtilt "" range:[-1.5,-0.6,-1.0]   type:#float align:#right scale:0.01 fieldwidth:60      pos:[(DYNiniExplorerWidth - 96),146]

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNcamParams open do
  (
    DYNcamParams.title = DYNuiRolloutNames[6]
    GBDYNgroup01.text  = DYNuiResourcesGroups[3]
    BUDYNview.text     = DYNuiResourcesButtons[42]
    LBDYNtarg.text     = DYNuiResourcesLabels[80]
    LBDYNfogN.text     = DYNuiResourcesLabels[81]
    LBDYNfogF.text     = DYNuiResourcesLabels[82]
    LBDYNtilt.text     = DYNuiResourcesLabels[83]
  )

  on DYNcamParams close do
  (
    LOCobj = undefined
  )

  --- Fog Near Spinner Controls
  on SPDYNfogN buttonDown  do (if LOCrangeSwitch then LOCobj.showRanges = true)
  on SPDYNfogN buttonUp    do (if LOCrangeSwitch then LOCobj.showRanges = false)
  on SPDYNfogN changed arg do
  (
    LOCobj.nearRange = arg
    if arg >= SPDYNfogF.value then
    (
      LOCobj.farRange = SPDYNfogF.value = arg
    )
  )

  --- Fog Far Spinner Controls
  on SPDYNfogF buttonDown  do (if LOCrangeSwitch then LOCobj.showRanges = true)
  on SPDYNfogF buttonUp    do (if LOCrangeSwitch then LOCobj.showRanges = false)
  on SPDYNfogF changed arg do
  (
    LOCobj.farRange = arg
    if arg <= SPDYNfogN.value then
    (
      LOCobj.nearRange = SPDYNfogN.value = arg
    )
  )

  --- Target Dist Spinner Controls
  on SPDYNtarg changed arg do (with undo label:DYNuiResourcesUndoLabels[6] LOCundoState (LOCcontroller.distance = arg / LOCparLength; LOCobj.target_Distance = if arg > 0.0 then arg else (arg * -1)))
  on SPDYNtarg buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNtarg.value)
  on SPDYNtarg buttonUp    do
  (
    if LOCspinStartValue != SPDYNtarg.value then
    (
      with undo off (LOCcontroller.distance = LOCspinStartValue / LOCparLength; LOCobj.target_Distance = if LOCspinStartValue > 0.0 then LOCspinStartValue else (LOCspinStartValue * -1))
      with undo label:DYNuiResourcesUndoLabels[6] on (LOCcontroller.distance = SPDYNtarg.value / LOCparLength; LOCobj.target_Distance = if SPDYNtarg.value > 0.0 then SPDYNtarg.value else (SPDYNtarg.value * -1))
    )
    LOCundoState    = on
  )


  --- Tilt Spinner Controls
  on SPDYNtilt changed arg do (with undo label:DYNuiResourcesUndoLabels[7] LOCundoState (in coordsys local (LOCobj.objectoffsetrot.x = arg)))
  on SPDYNtilt buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNtilt.value)
  on SPDYNtilt buttonUp    do
  (
    if LOCspinStartValue != SPDYNtilt.value then
    (
      with undo off (in coordsys local (LOCobj.objectoffsetrot.x = LOCspinStartValue))
      with undo label:DYNuiResourcesUndoLabels[7] on (in coordsys local (LOCobj.objectoffsetrot.x = SPDYNtilt.value))
    )
    LOCundoState    = on
  )


  --- Others
  on BUDYNview pressed do (undo off viewPort.setCamera LOCobj)

  on DDVISobjectParam selected arg do
  (
    undo off LOCobj.fov = DYNfovSizes[arg]
  )
)
